<?php
// this script was implemented and tested with php5 on a linux/apache2 machine.
// It's a proof of concept and not intended to be very secure.

//----------------------------------------------------------------------------
// config & credentials
define("_SERVER", "http://62.116.179.213/");
define("_API", "BvLTech1.afp");
// Auth 1/2
$user = "Archivio3";
$pass = "333";
// Auth 2/2
$user2 = "user1";
$pass2 = "pass1";


//----------------------------------------------------------------------------
// performs first step in authorisation chain. returns curl_handle
function  auth1()
{
  global $user; global $pass;
  // Open connection to server and authorize via http request
  $ch = curl_init();
  curl_setopt($ch, CURLOPT_URL, _SERVER._API);
  curl_setopt($ch, CURLOPT_HEADER, 0);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($ch, CURLOPT_USERPWD, "$user:$pass"); // first auth step!
  $info = curl_getinfo($ch);
  curl_exec($ch);

  $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  if ($httpCode != 200) // we only accept HttpStatus 200 OK
    throw new Exception("Authorisation (1/2) failed. Got http status code $httpCode instead of 200 (OK).");

  return $ch; // if you're using older versions than php5 you should return &$ch 
}

//----------------------------------------------------------------------------
// 2nd step... return our sessionID
function auth2(&$ch)
{
  global $user2; global $pass2; // use global vars
  // 2nd step: authorise via afp page
  $url = _SERVER._API."?bvl1=!bvli!&bvl2=$user2&bvl3=$pass2";
  curl_setopt($ch, CURLOPT_URL, $url);
  $page = curl_exec($ch);
  $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  if ($httpCode != 200) // we only accept HttpStatus 200 OK
    throw new Exception("Authorisation (2/2) failed. Got http status code $httpCode instead of 200 (OK).");

  //if login was successfull, there is a link with title="LOGOUT" and our username in UPPERCASE
  $lp = strpos($page, "LOGOUT");
  $up = strpos($page, strtoupper($user2));

  if(!( (0 < $lp) && ($lp < $up)))
    throw new Exception("Authorisation (2/2) failed. There was no server error, but we're not logged in.");

  // extract SessionID
  $sidTag = "IHRE_SESSION_ID";
  $sidStart = strpos($page,"<".$sidTag.">")+strlen("<".$sidTag.">");
  $sidEnd = strpos($page,"</".$sidTag.">");
  $sidLen = $sidEnd - $sidStart;
  $sessionID = substr($page,$sidStart,$sidLen);
  return $sessionID;
}

//----------------------------------------------------------------------------
// returns an array of results. Accepts only one keyword!
function queryArchivio(&$ch, $sessionID, $keyword)
{
  $url =  _SERVER._API."?bvl2511=$sessionID&BvL1=$keyword";
  curl_setopt($ch, CURLOPT_URL, $url);
  $response = curl_exec($ch);
  $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  if ($httpCode != 200) // we only accept HttpStatus 200 OK
    throw new Exception("Query for $keyword failed. Got http status code $httpCode instead of 200 (OK).");
  // got our result page. Now parsing...
  $itemTag="BVL_ARCHIVIO_LINK";
  preg_match_all("|<".$itemTag.">(.*)</".$itemTag.">|U",$response,$matches,PREG_SET_ORDER);

  if (count($matches) == 0) return;
  foreach($matches as $match)
	$results[] = $match[1];

  return $results;
}

//----------------------------------------------------------------------------
// saves the resource @URL in %temp%/filename.ext
// on the machine this script is running. Returns path/to/file.ext
function download_file($ch, $url)
{
  //get file name
  $fnOffset= strpos($url,"brnvl=")+6;
  $fnLen = strpos($url,"&",$fnOffset)-$fnOffset;
  $fn = substr($url,$fnOffset,$fnLen);
  //get file extension
  $extOffset= strpos($url,"crnvl=")+6;
  $extLen = strlen($url)-$extOffset;
  $ext = substr($url,$extOffset,$extLen);

  //build filename and path to tmpfile
  $fname = "$fn.$ext";

  $tempfile=sys_get_temp_dir().'/'.$fname;
  // if that file is cached in tmp, we're good to skip the download
  if(is_file($tempfile))
    return $tempfile;

  // we're ready to go, but.. the url doesn't link to file
  // there is a page between us. handle this!
  curl_setopt($ch, CURLOPT_URL, $url);
  $page = curl_exec($ch);
  $urlOffset = strpos($page,'<a href="')+9;
  $urlLen = strpos($page,'"',$urlOffset)-$urlOffset;
  $url = substr($page,$urlOffset,$urlLen);

  // Download file to systems temp dir
  curl_setopt($ch, CURLOPT_URL, $url);
  $fp = fopen($tempfile,"wb");
  //sth went wrong...
  if ($fp == null || $fp == false)
   throw new Exception("Failed to open file handle to $tempfile. Please check permissions.");
  curl_setopt($ch, CURLOPT_FILE, $fp);
  curl_exec($ch);
  fclose($fp);
  return $tempfile;
}





try
{
  $ch = auth1();
  $sessionID = auth2($ch);
  $keyword = "Datenschutz";
  $results = queryArchivio($ch, $sessionID, $keyword);

  if (count($results) < 1)
    throw new Exception("The query for '$keyword' returned nothing.");

  // donwload file, patching it thru
  $file = download_file($ch,$results[0]);
  curl_close($ch);
  header('Content-Description: File Transfer');
  header('Content-Type: application/pdf');
  header('Content-Disposition: attachment; filename='.basename($file));
  header('Content-Transfer-Encoding: binary');
  header('Expires: 0');
  header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
  header('Pragma: public');
  header('Content-Length: ' . filesize($file));
  ob_clean();
  readfile($file);
}
catch(Exception $e)
{
  die("<h1>Oh, no.. Not that again</h1>
<p>Here's the exception I've got. Maybe you gave me wrong information?</p>
<hr><br><br><br><pre>$e</pre>"); 
}


?>
