﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Net;
using System.Windows;

namespace Archivio
{
  public partial class MainWindow
  {
    public MainWindow()
    {
      InitializeComponent();
      SearchText.Focus();
    }

    // ==========================================================================================================
    // Suchen
    private void Button_Click(object sender, RoutedEventArgs e)
    {
      using (var client = new WebClient())
      {
        // Die Zugangsdaten zum Archivio-Server
        client.Credentials = new NetworkCredential("Archivio1", "111");

        // Den Suchtext übergeben. Weitere Suchbegriffe können über bvl2, bvl3, usw. übergeben werden
        client.QueryString.Add("bvl1", SearchText.Text);

        // Lädt die Ergebnisseite im HTML Format herunter. Diese könnte jetzt im Browser
        // angezeigt werden.
        string htmlCode = client.DownloadString("http://62.116.179.211/BvLTech1.afp");
        if (!htmlCode.Contains("%BVLTEXTDATEILINK%"))
        {
          MessageBox.Show("Die Suche ergab keinen Treffer!");
          return;
        }

        // In der Ergebnisseite ist ein Link auf eine Textdatei untergebracht. Diese
        // Textdatei enthält alle Treffer in einem auswertbarem Format.
        var fileUrl = StringExtract(htmlCode, "%BVLTEXTDATEILINK%", "%/BVLTEXTDATEILINK%");
        var resultFile = client.DownloadString(fileUrl);
        var result = resultFile.Split('\n');

        // Textdatei mit allen Treffern auswerten und in ein Dictionary aufnehmen. Dieses
        // enthält als Wert den Treffertext und als Schlüssel die Url zum Herunterladen.
        var list = new Dictionary<String, String>();
        String text = null, key = null;
        foreach (var s in result)
        {
          if (s.Length > 10 && s.Substring(0, 8) == "%BvLText")
          {
            var t = s.Substring(9);
            text = t.Substring(t.IndexOf('%') + 1, t.LastIndexOf("%/BvLText", StringComparison.Ordinal) - 1);
          }
          if (s.Length > 10 && s.Substring(0, 8) == "%BvLLink")
          {
            var t = s.Substring(9);
            key = t.Substring(t.IndexOf('%') + 1, t.LastIndexOf("%/BvLLink", StringComparison.Ordinal) - 1);
          }
          if (text != null && key != null)
          {
            list.Add(key, text);
            key = null;
            text = null;
          }
        }

        Result.ItemsSource = list;
      }
    }

    // ==========================================================================================================
    // Anzeigen
    private void Button_Click_1(object sender, RoutedEventArgs e)
    {
      if (Result.SelectedValue == null)
        return;

      // Der Anwender hat einen Eintrag gewählt und möchte diesen anzeigen
      var url = (String)Result.SelectedValue;
      var ext = url.Substring(url.LastIndexOf('=') + 1);

      using (var client = new WebClient())
      {
        // Die Zugangsdaten zum Archivio-Server
        client.Credentials = new NetworkCredential("Archivio1", "111");

        // Die Url enthält nicht direkt die gewünschte Datei, sondern eine weitere
        // HTML Seite, die per Meta-Refresh die eigentliche Datei herunterlädt. Wir
        // ermitteln die Url der zu ladenden Datei.
        var result = client.DownloadString(url);
        url = StringExtract(result, "<a href=\"", "\"");

        // Die Datei (PDF-Dokument, MSG Datei, etc.) wird in das temporäre Verzeichnis
        // heruntergeladen und von dort über den Standardviewer geladen.
        var file = System.IO.Path.GetTempPath() + Guid.NewGuid() + "." + ext;
        client.DownloadFile(url, file);
        Process.Start(file);
      }
    }

    // ==========================================================================================================
   // Auf gut Glück
    private void Button_Click_2(object sender, RoutedEventArgs e)
    {
      using (var client = new WebClient())
      {
        // Die Zugangsdaten zum Archivio-Server
        client.Credentials = new NetworkCredential("Archivio1", "111");

        // Den Suchtext übergeben. Weitere Suchbegriffe können über bvl2, bvl3, usw. übergeben werden
        client.QueryString.Add("bvl1", SearchText.Text);

        // Lädt die Ergebnisseite im HTML Format herunter. Diese könnte jetzt im Browser
        // angezeigt werden.
        string htmlCode = client.DownloadString("http://62.116.179.211/BvLTech1.afp");

        if (htmlCode.Contains("<BVL_ARCHIVIO_LINK>"))
        {
          // Im HTML Dokument sind alle Links mit BVL_ARCHIVIO_LINK gekennzeichnet. Da uns hier nur
          // der erste Treffer interessiert und wir keinen Text anzeigen müssen, können wir den
          // Link direkt extrahieren.
          var urlHit = StringExtract(htmlCode, "<BVL_ARCHIVIO_LINK>", "</BVL_ARCHIVIO_LINK>");

          // Die Dateiendung ergibt sich aus dem letzten Parameter der URL.
          var ext = urlHit.Substring(urlHit.LastIndexOf('=') + 1);

          // Die Url enthält nicht direkt die gewünschte Datei, sondern eine weitere
          // HTML Seite, die per Meta-Refresh die eigentliche Datei herunterlädt. Wir
          // ermitteln die Url der zu ladenden Datei.
          var result2 = client.DownloadString(urlHit);
          var url = StringExtract(result2, "<a href=\"", "\"");

          // Die Datei (PDF-Dokument, MSG Datei, etc.) wird in das temporäre Verzeichnis
          // heruntergeladen und von dort über den Standardviewer geladen.
          var file = System.IO.Path.GetTempPath() + Guid.NewGuid() + "." + ext;
          client.DownloadFile(url, file);
          Process.Start(file);
        }
        else
        {
          MessageBox.Show("Die Suche ergab keinen Treffer!");
        }
      }
    }
  
    String StringExtract(string src, string start, string end)
    {
      var pos = src.IndexOf(start, StringComparison.Ordinal) + start.Length;
      var s = src.Substring(pos);
      var length = s.IndexOf(end, StringComparison.Ordinal);
      s = s.Substring(0, length);
      return s;
    }

  }
}
